// By EVOLVED
// www.evolved-software.com

//--------------
// Textures
//--------------
   texture ReflectionTexture <string Name = " ";>;
   sampler ReflectionSampler=sampler_state 
      {
	Texture=<ReflectionTexture>;
        ADDRESSV=CLAMP;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex0:TEXCOORD0;
     };
   struct OutPut
     {
 	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0;
 	float Blur:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN)
     {
        OutPut OUT; 
	float2 Pos=(float2(IN.Pos.x,IN.Pos.y)+1.0)*0.5;
	if(IN.Tex0.x<1.5) {
         Pos=float2(Pos.x*0.75294117647,(Pos.y*0.25)+((4-IN.Tex0.y)*0.25))*2.0-1.0;
	 OUT.Blur=0.0001;
        }
        else {
	 if(IN.Tex0.x<2.5) { 
	  Pos=float2(0.75294117647+(Pos.x*0.18823529411),(Pos.y*0.0625)+((16-IN.Tex0.y)*0.0625))*2.0-1.0;
 	  OUT.Blur=0.0015;
         }
         else {
	  Pos=float2(0.94117647058+(Pos.x*0.04705882352),(Pos.y*0.015625)+((64-IN.Tex0.y)*0.015625))*2.0-1.0;
 	  OUT.Blur=0.02;
         }
        }
	OUT.Pos=float4(Pos.xy,1.0,1.0);
 	OUT.Tex=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
        return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(OutPut IN)  : COLOR
     {
	float4 ReflectionBlur=0;
	for(int x = -12; x < 12; x++) {
    	 for(int y = -12; y < 12; y++) {
	  float Weight=(16-length(float2(x,y)));
       	  float4 Reflection=tex2D(ReflectionSampler,IN.Tex+float2(x,y)*IN.Blur);
	  ReflectionBlur +=float4(Reflection.xyz*pow(1.04,Reflection.w*255.0-128.0),1.0)*Weight;
         }
	}
	float4 FrameRender=ReflectionBlur/ReflectionBlur.w;
	float MaxComponent=max(max(FrameRender.x,FrameRender.y),FrameRender.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(FrameRender.xyz/pow(1.04,fExp*255.0-128.0),fExp);
     }

//--------------
// techniques   
//--------------
    technique Equirectangular
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS(); 
      }
      }
